import urllib.parse as urlparse
from http.server import BaseHTTPRequestHandler, HTTPServer

class CallbackHandler(BaseHTTPRequestHandler):
    def do_GET(self):
        parsed_path = urlparse.urlparse(self.path)
        query_params = urlparse.parse_qs(parsed_path.query)
        if 'code' in query_params:
            self.send_response(200)
            self.end_headers()
            self.wfile.write(b"Authorization code received.")
            authorization_code = query_params['code'][0]

            # Get cookie
            cookie = self.headers.get('Cookie')

            # Exchange the authorization code for an access token
            self.server.path = self.path # type: ignore
            self.server.cookie = cookie # type: ignore
            self.server.headers = self.headers # type: ignore
        else:
            self.send_response(400)
            self.end_headers()
            self.wfile.write(b"Authorization code not found.")

    def log_message(self, format, *args):
        return

def start_server(port=8091):
    server_address = ('', port)
    httpd = HTTPServer(server_address, CallbackHandler)
    print('Starting server, use <Ctrl-C> to stop')
    httpd.handle_request()
    return httpd.path, httpd.cookie, httpd.headers
