import httpx
import rich
import webbrowser

from oidcflow import OIDCAuth

# OIDC configuration
client_id = "test"
client_secret = "94XHrfNRwXsjqTqApRrwWmhDLDHpIYV8"
redirect_uri = 'http://localhost:8091/callback'
discovery_url = 'http://keycloak.mydomain.com:8090/realms/test/.well-known/openid-configuration'

# Set up the OIDC authentication
auth = OIDCAuth(
    client_id=client_id,
    client_secret=client_secret,
    discovery_url=discovery_url,
)

# Example 1: Get user info
endpoint = "http://localhost:8080/api/users/:me"
response = httpx.get(endpoint, auth=auth)

rich.print("[bold]\nUser info[/bold]")
rich.print(response.json())

# Example 2: Get collection content (Should not redirect, since the bearer token is already set)
endpoint = "http://localhost:8080/api/dataverses/hello/contents"
response = httpx.get(endpoint, auth=auth)

rich.print("[bold]\nDataverse content[/bold]")
rich.print(response.json())
